1. tools/validate_declaration.py
Intended Use: This script is designed for offline validation of ANDS declaration JSON files. It ensures that a vendor's declaration (typically hosted at /.well-known/ands.json) adheres to the standard schema. It can also perform Ed25519 signature verification to confirm the integrity and authenticity of the declaration if a signature block is provided.

2. tools/ands_scan.py
Intended Use: This is an evidence-gathering scanner for AI systems. It takes a target URL and performs several non-invasive checks:

It attempts to fetch the declared ANDS file.
It scans for an openapi.json file to identify capability hints (e.g., tool use, code execution, RBAC).
It performs optional "verification probes" on common endpoints (e.g., /health, /execute) to check for basic protection (authentication gating).
It outputs a detailed JSON report containing both declared and inferred ANDS codes, a confidence score, and identified gaps/recommendations.
3. tools/report/render_report.py
Intended Use: This utility converts the technical JSON report generated by ands_scan.py into a human-readable Markdown format. It supports both a technical 'report' template and an executive 'scorecard' template.

4. tools/ands_init.py
Intended Use: An interactive wizard to help vendors create and sign their ands.json declaration file using RFC 8785 (JCS) and Ed25519.

5. tools/ands_badge.py
Intended Use: Generates a professional SVG badge for an ANDS score, suitable for READMEs or websites.

6. tools/ands_ci.py
Intended Use: A CI-optimized validator that provides GitHub Action annotations and exit codes for automated pipelines.

7. tools/ands_summarize.py
Intended Use: Aggregates multiple scan reports into a single comparative Markdown or CSV table for portfolio analysis.

8. tools/ands_mock_server.py
Intended Use: A reference implementation of an ANDS-compliant AI server for testing and demonstration purposes.

9. tools/ands_bulk_scan.py
Intended Use: A multi-threaded parallel scanner for processing large portfolios of AI systems.

10. Dockerfile
Intended Use: A portable, production-ready container environment for running the entire ANDS toolkit.

11. tools/ands_ping.py
Intended Use: A high-speed availability and integrity monitor for ANDS declarations.

12. tools/ands_mcp.py
Intended Use: An MCP (Model Context Protocol) server allowing AI agents to perform ANDS scans and validations.

13. tools/ands_discover.py
Intended Use: A high-speed network discovery tool to find AI systems exposing ANDS declarations within IP ranges.

14. action.yml
Intended Use: A formal GitHub Action to automate ANDS declaration validation in CI/CD pipelines.

15. tools/ands_verify_bundle.py
Intended Use: A forensic tool to verify the integrity and provenance of .andsz audit bundles.

16. tools/ands_guard.py
Intended Use: A reverse-proxy that enforces ANDS risk policies in real-time by blocking traffic to high-risk systems.

17. tools/ands_registry.py
Intended Use: A registry server (The Oracle) that indexes and periodically re-scans a fleet of AI systems.

18. tools/ands_serve.py
Intended Use: A zero-code way for vendors to serve a compliant ands.json declaration and a live HTML scorecard.

19. tools/ands_explorer.py
Intended Use: Generates a portable, interactive HTML dashboard for auditing large portfolios of AI systems.

20. tools/ands_simulate.py
Intended Use: A risk simulation engine that translates ANDS profiles into descriptive failure scenarios for insurers.
